//
//  NewTransactionViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 29.05.22.
//

import UIKit
import CodeScanner
import JNGradientLabel

class NewTransactionViewController: UIViewController {
    
    
    @IBOutlet weak var topBarLabel: JNGradientLabel!
    
    @IBOutlet weak var errorWrongQRCode: UILabel!
    
    
    @IBOutlet var fromBankAccountLabel: UILabel!
    
    
    @IBOutlet weak var detailsLabel: UILabel!
    
    @IBOutlet weak var accountGiroAmountLabel: UILabel!
    @IBOutlet weak var accountHeaderLabel: UILabel!
    
    
    @IBOutlet var newTransactionTextLabel: UILabel!
    
    @IBOutlet weak var transferMoneyButton: UIButton!
    
    @IBOutlet weak var fullCornerLabel: UILabel!
    
    //@IBOutlet weak var transferMoneyJNGradientLabel: LeftAlignedIconButton!
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        returnedFromTransactionSummaryView = false
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        /*
        if bugBoolean == false {
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionFormularNC") as! UINavigationController
            self.view.window?.rootViewController = vc
            self.view.window?.makeKeyAndVisible()
        }
        */
         
        // top bar gradient color
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        // hide Error label
        errorWrongQRCode.alpha = 0
        if showErrorMessageQrCodeScanFailedPublic {
            errorWrongQRCode.alpha = 1
            errorWrongQRCode.text = "Bitte scannen Sie einen validen QR Code."
        } else if showErrorMessageWrongQRCodePublic {
            errorWrongQRCode.alpha = 1
            errorWrongQRCode.text = "Bitte scannen Sie einen gültigen EPC-QR Code, d.h. ein QR Code für SEPA Lastschriftüberweisungen (Girocode)."
        }
        
        errorWrongQRCode.textColor = Colors.carmine
        errorWrongQRCode.font = Fonts.lightFontWithSize(size: 16)
        
        //transferMoneyButton.imageV.image = UIImage(named: "eurosign.square")
        //transferMoneyButton.titleV.text = "Neue Übweisung"
        //scanQRCodeButton.imageV.image = UIImage(named: "qrcode")
        //scanQRCodeButton.titleV.text = "Scan QR Code"
        
        //transferMoneyButton.setLeftImage(imageName: "qrcode", padding: 30.0)
        // style buttons
        
        
        
        
        //transferMoneyButton.moveImageLeftTextCenter()
        
        //transferMoneyButton.moveImageLeftTextCenter(image: UIImage(systemName: "qrcode")!, imagePadding: 3.0, renderingMode: .alwaysTemplate)
        
        //transferMoneyButton.titleLabel?.textAlignment = .center
        
        
        
        //Utilities.styleFilledButtonAuthScreenGreenEdged(scanQRCodeButton)
    
        
        fromBankAccountLabel.font = Fonts.heavyFontWithSize(size: 20)
        
        newTransactionTextLabel.font = Fonts.mediumFontWithSize(size: 17)
        
        transferMoneyButton.isUserInteractionEnabled = true
        Utilities.styleFilledButtonNewTransBlue(transferMoneyButton)
        transferMoneyButton.moveImageLeftTextCenter()
        //scanQRCodeButton.moveImageLeftTextCenter()
        
        
        // see https://www.youtube.com/watch?v=Dh7fa1fdzBo
        NotificationCenter.default.addObserver(self, selector: #selector(didGetErrorNotification(_:)), name: Notification.Name("text"), object: nil)
        
        // Create Attachment
        let imageAttachment = NSTextAttachment()
        imageAttachment.image = UIImage(named:"IconGreenBulbEuro_small")
        // Set bound to reposition
        let imageOffsetY: CGFloat = -5.0
        imageAttachment.bounds = CGRect(x: 0, y: imageOffsetY, width: imageAttachment.image!.size.width, height: imageAttachment.image!.size.height)
        // Create string with attachment
        let attachmentString = NSAttributedString(attachment: imageAttachment)
        // Initialize mutable string
        let completeText = NSMutableAttributedString(string: "")
        // Add image to mutable string
        completeText.append(attachmentString)
        // Add your text to mutable string
        let textAfterIcon = NSAttributedString(string: " Accounts") // Girokonto
        completeText.append(textAfterIcon)
        self.accountHeaderLabel.textAlignment = .left
        self.accountHeaderLabel.attributedText = completeText
        
        accountHeaderLabel.layer.cornerRadius = 10
        accountHeaderLabel.layer.masksToBounds = true
        accountHeaderLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner]
        
        accountHeaderLabel.font = Fonts.heavyFontWithSize(size: 18)
        
        detailsLabel.layer.cornerRadius = 10
        detailsLabel.layer.masksToBounds = true
        detailsLabel.layer.maskedCorners = [.layerMinXMaxYCorner]
        
        detailsLabel.numberOfLines = 0
        detailsLabel.lineBreakMode = .byTruncatingTail
        
        detailsLabel.font = Fonts.mediumFontWithSize(size: 16)
        let details = NSMutableAttributedString.init(string: "   LightBanking Giro Premium\n   DE12 2707 0369 1128 5096 19")
        
        details.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                   range: NSMakeRange(0, 28)) // 25
        
        detailsLabel.attributedText = details
        
        
        fullCornerLabel.layer.cornerRadius = 10
        fullCornerLabel.layer.masksToBounds = true
        fullCornerLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner, .layerMinXMaxYCorner, .layerMaxXMaxYCorner]
        fullCornerLabel.layer.borderColor = UIColor.init(red: 30/255, green: 91/255, blue: 158/255, alpha: 1).cgColor //UIColor.init(red: 58/255, green: 181/255, blue: 78/255, alpha: 1).cgColor
        fullCornerLabel.layer.borderWidth = 2.0

        
        accountGiroAmountLabel.layer.cornerRadius = 10
        accountGiroAmountLabel.layer.masksToBounds = true
        accountGiroAmountLabel.layer.maskedCorners = [.layerMaxXMaxYCorner]
        
        accountGiroAmountLabel.textAlignment = .right
        
        // calculate giro account amount (based on whether user transaction took place or not
        // User Transaction did not took place
        var amountGiroAccountString : String = ""
        var sumGiroAccount : Float = 0.00
        let defaults = UserDefaults.standard
        if defaults.object(forKey: "amountGiroAccount") != nil {
            let amountGiroAccountAfterTransaction = defaults.float(forKey: "amountGiroAccount")
            //sumGiroAccount = amountGiroAccountPublic-userTransactionAmountDouble
            sumGiroAccount = amountGiroAccountAfterTransaction
            print("amountGiroAccountPublic:")
            print(amountGiroAccountPublic)
            print("userTransactionAmountDouble:")
            print(amountGiroAccountAfterTransaction)
            
        } else { // User transaction done
            sumGiroAccount = amountGiroAccountPublic
        }
        
        amountGiroAccountString = String(format: "%.2f", sumGiroAccount).replacingOccurrences(of: ".", with: ",") + " €"
        
        Utilities.addDotsToBankBalance(sumFloat: sumGiroAccount ,sumString: &amountGiroAccountString)
         
        let accountGiroAmountStringAttributes = NSMutableAttributedString.init(string: amountGiroAccountString + "--")
        
        accountGiroAmountStringAttributes.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 17, weight: .semibold),
                                    NSAttributedString.Key.foregroundColor: UIColor(red: 65.0/255.0, green: 109.0/255.0, blue: 186.0/255.0, alpha: 1.0)],
                                              range: NSMakeRange(0, amountGiroAccountString.count))
        
        accountGiroAmountLabel.attributedText = accountGiroAmountStringAttributes
        
        accountGiroAmountLabel.font = Fonts.mediumFontWithSize(size: 17)
        
        
        if (cameraAccessInstructionsPublic == true) {
            cameraAccessInstructionsPublic = false
            
            if #available(iOS 15.0, *) {
            
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let nc = storyboard.instantiateViewController(withIdentifier: "QRCodeAllowanceNC")
                    
            
                if let presentationController = nc.presentationController as? UISheetPresentationController {

                    presentationController.detents = [.medium()] /// change to [.medium(), .large()] for a half *and* full screen sheet
                }
                    self.present(nc, animated: true)
            
            } else {
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                        let viewController = storyboard.instantiateViewController(withIdentifier: "QRCodeAllowanceVC")
                viewController.modalPresentationStyle = .custom
                viewController.transitioningDelegate = self
                self.present(viewController, animated: true, completion: nil)
            }
            
            
            
        }
        
        
    }
    
    // error if QR code is not valid
    @objc func didGetErrorNotification(_ notification: Notification) {
        let text = notification.object as! String?
        errorWrongQRCode.alpha = 1
        errorWrongQRCode.text = "Please scan the correct QR code." // normally do this: = text
    }
    
    // "Neue Überweisung" Button
    @IBAction func transferMoneyButton(_ sender: Any) {
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
                let viewController = storyboard.instantiateViewController(withIdentifier: "TransactionOptionsVC")
        viewController.modalPresentationStyle = .custom
        viewController.transitioningDelegate = self
        self.present(viewController, animated: true, completion: nil)
    }
    
    
    // unimportant stuff...
    func appendImageToString() {
        
        let fullString = NSMutableAttributedString(string:"")

         // create our NSTextAttachment
        let image1Attachment = NSTextAttachment()
        image1Attachment.image = UIImage(named: "bankingappLogo")
        image1Attachment.bounds = CGRect(x: 0, y: -0, width: 25, height: 25)

        // wrap the attachment in its own attributed string so we can append it
        let image1String = NSAttributedString(attachment: image1Attachment)

         // add the NSTextAttachment wrapper to our full string, then add some more text.

         fullString.append(image1String)
         fullString.append(NSAttributedString(string:"Konten"))

         // draw the result in a label
        accountHeaderLabel.attributedText = fullString
        
       
    }
    
    
    
    private func makeEffectView() {
        let effect: UIBlurEffect = UIBlurEffect(style: UIBlurEffect.Style.light)
            let effectView = UIVisualEffectView(effect: effect)
            effectView.frame = CGRect(x:0, y:0, width:UIScreen.main.bounds.size.width, height:UIScreen.main.bounds.size.height)
        self.view.addSubview(effectView)
        
        
        }
    
    
}

extension UIButton {
    func moveImageLeftTextCenter(imagePadding: CGFloat = 30.0, titlePadding: CGFloat = 0.0, minImageTitleDistance: CGFloat = 10.0){
    guard let imageViewWidth = imageView?.frame.width else{return}
    guard let titleLabelWidth = titleLabel?.intrinsicContentSize.width else{return}
    contentHorizontalAlignment = .left

    let imageLeftInset = imagePadding - imageViewWidth / 2
    var titleLeftInset = (bounds.width - titleLabelWidth) / 2 - imageViewWidth + titlePadding

    if titleLeftInset - imageLeftInset < minImageTitleDistance{
        titleLeftInset = imageLeftInset + minImageTitleDistance
    }

    imageEdgeInsets = UIEdgeInsets(top: 0.0, left: imageLeftInset, bottom: 0.0, right: 0.0)
    titleEdgeInsets = UIEdgeInsets(top: 0.0, left: titleLeftInset, bottom: 0.0, right: 0.0)
    
        
        if #available(iOS 15.0, *) {
            self.configuration!.imagePadding = imageLeftInset
            self.configuration!.titlePadding = titleLeftInset
        } else {
            // Fallback on earlier versions
        }
        
        
    }
}

extension UIButton {
func centerImageLeft(padding: CGFloat = 30.0){
    let buttonWidth = self.frame.width
    let textWidth = self.titleLabel?.intrinsicContentSize.width ?? 0
    let imageViewWidth = self.imageView?.frame.size.width ?? 0
    let offsetToLeftButtonEdge = buttonWidth - textWidth - imageViewWidth
    let offset = offsetToLeftButtonEdge - padding

    
    if #available(iOS 15.0, *) {
        self.configuration!.imagePadding = offset
        //self.configuration!.titlePadding = buttonWidth/2
        self.configuration!.contentInsets = NSDirectionalEdgeInsets(top: 0.0, leading: 0.0, bottom: 0.0, trailing: 0.0)
    } else {
        // Fallback on earlier versions
    }
}
}

// MARK: - UIViewControllerTransitioningDelegate
extension NewTransactionViewController: UIViewControllerTransitioningDelegate {
    
    func presentationController(forPresented presented: UIViewController, presenting: UIViewController?, source: UIViewController) -> UIPresentationController? {
        PresentationController(presentedViewController: presented, presenting: presenting)
    }
}
